# Dense Prediction

## Installation
`conda create -n repaformer_dense_pred python=3.8`  
`conda activate repaformer_dense_pred`  
`conda install pytorch torchvision pytorch-cuda=12.1 -c pytorch -c nvidia`  
`pip install einops timm ftfy regex`  
`pip install openmim`  
`mim install mmengine`  
`mim install "mmcv==2.1.0"`  
`cd ./mmsegmentation`  
`pip install -e .`  
`cd ../mmdetection`  
`pip install -e .`  

## Implementation
Our RePa-Swin model is implemented in `./mmsegmentation/mmseg/models/backbones/repaswin.py` and `./mmdetection/mmdet/models/backbones/repaswin.py`.

## Data Preparation
Please refer to the following links for ADE20K and MSCOCO dataset preparation: [ADE20K](https://mmsegmentation.readthedocs.io/en/main/user_guides/2_dataset_prepare.html) and [MSCOCO](https://mmdetection.readthedocs.io/en/latest/user_guides/dataset_prepare.html). 

## Training
`cd ./mmsegmentation`  
RePa-Swin-Small UperNet  
`python tools/train.py configs/repaswin/repaswin-small-upernet_ade-pretrain-channel-idle.py`  
RePa-Swin-Base UperNet  
`python tools/train.py configs/repaswin/repaswin-base-upernet_ade-pretrain-channel-idle.py`  
`cd ./mmdetection`  
RePa-Swin-Small Retinanet  
`python tools/train.py configs/repaswin/retinanet_repaswin-small-p4-w7_fpn_1x_coco.py`  
RePa-Swin-Base Retinanet  
`python tools/train.py configs/repaswin/retinanet_repaswin-base-p4-w7_fpn_1x_coco.py`  
RePa-Swin-Small Mask R-CNN  
`python tools/train.py configs/repaswin/mask-rcnn_repaswin-small-coco-1x.py`  
RePa-Swin-Base Mask R-CNN  
`python tools/train.py configs/repaswin/mask-rcnn_repaswin-base-coco-1x.py`  
